rule ByteCode_MSIL_Ransomware_GoodWill : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GOODWILL"
        description         = "Yara rule that detects GoodWill ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "GoodWill"
        tc_detection_factor = 5

    strings:

        $encrypt_file = {
            02 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 0A 28 ?? ?? ?? ?? 06 6F
            ?? ?? ?? ?? 0A 06 28 ?? ?? ?? ?? 0B 02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0C 02 72 ?? ?? ??
            ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 08 07 28 ?? ?? ?? ?? 02 28 ?? ?? ?? ?? DE ?? 26 72 ??
            ?? ?? ?? 28 ?? ?? ?? ?? DE ?? 2A
        }

        $aes_encrypt = {
            14 0A 03 0B 73 ?? ?? ?? ?? 0C 73 ?? ?? ?? ?? 0D 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 09 20
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 03 07 20 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 09 11 ?? 09 6F ??
            ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ??
            ?? ?? 6F ?? ?? ?? ?? 09 17 6F ?? ?? ?? ?? 08 09 6F ?? ?? ?? ?? 17 73 ?? ?? ?? ?? 13 ??
            11 ?? 02 16 02 8E 69 6F ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? DE ?? 11 ?? 2C ?? 11 ?? 6F ??
            ?? ?? ?? DC 08 6F ?? ?? ?? ?? 0A DE ?? 09 2C ?? 09 6F ?? ?? ?? ?? DC 08 2C ?? 08 6F ??
            ?? ?? ?? DC 06 2A
        }

        $find_files_p1 = {
            28 ?? ?? ?? ?? 0A 1F ?? 28 ?? ?? ?? ?? 0B 18 8D ?? ?? ?? ?? 25 16 72 ?? ?? ?? ?? A2 25
            17 72 ?? ?? ?? ?? A2 0C 06 0D 16 13 ?? 38 ?? ?? ?? ?? 09 11 ?? 9A 13 ?? 11 ?? 6F ?? ??
            ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? DD ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 13 ?? 11
            ?? 28 ?? ?? ?? ?? 08 13 ?? 16 13 ?? 38 ?? ?? ?? ?? 11 ?? 11 ?? 9A 13 ?? 11 ?? 28 ?? ??
            ?? ?? 6F ?? ?? ?? ?? 13 ?? 2B ?? 11 ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 11 ?? 17 28 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 13 ?? 2B ?? 73 ?? ?? ?? ?? 13 ?? 11 ?? 11 ?? 6F ?? ?? ?? ?? 7D ?? ??
            ?? ?? 11 ?? FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 19 6F ?? ?? ?? ?? 6F ??
            ?? ?? ?? DE ?? 26 DE ?? 11 ?? 6F ?? ?? ?? ?? 2D ?? DE ?? 11 ?? 2C ?? 11 ?? 6F ?? ?? ??
            ?? DC DE ?? 26 DE ?? 26 DE ?? 11 ?? 6F ?? ?? ?? ?? 2D ?? DE ?? 11 ?? 2C ?? 11 ?? 6F ??
            ?? ?? ?? DC 11 ?? 11 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 2B ?? 73 ?? ?? ?? ?? 13 ??
            11 ?? 11 ?? 6F ?? ?? ?? ?? 7D ?? ?? ?? ?? 11 ?? FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 73 ??
            ?? ?? ?? 25 19 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? DE ?? 26 DE ?? 11 ?? 6F ?? ?? ?? ?? 2D ??
            DE ?? 11 ?? 2C ?? 11 ?? 6F ?? ?? ?? ?? DC DE ?? 26 DE ?? 11 ?? 17 58 13 ?? 11 ?? 11 ??
            8E 69 3F ?? ?? ?? ?? DE ?? 26 DE ?? 11 ?? 17 58 13 ?? 11 ?? 09 8E 69 3F ?? ?? ?? ?? 08
        }

        $find_files_p2 = {
            13 ?? 16 13 ?? 38 ?? ?? ?? ?? 11 ?? 11 ?? 9A 13 ?? 07 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13
            ?? 2B ?? 11 ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 11 ?? 17 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ??
            2B ?? 73 ?? ?? ?? ?? 13 ?? 11 ?? 11 ?? 6F ?? ?? ?? ?? 7D ?? ?? ?? ?? 11 ?? FE 06 ?? ??
            ?? ?? 73 ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 19 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? DE ?? 26 DE ??
            26 DE ?? 11 ?? 6F ?? ?? ?? ?? 2D ?? DE ?? 11 ?? 2C ?? 11 ?? 6F ?? ?? ?? ?? DC DE ?? 26
            DE ?? 11 ?? 6F ?? ?? ?? ?? 2D ?? DE ?? 11 ?? 2C ?? 11 ?? 6F ?? ?? ?? ?? DC 07 11 ?? 28
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 2B ?? 73 ?? ?? ?? ?? 13 ?? 11 ?? 11 ?? 6F ?? ?? ?? ??
            7D ?? ?? ?? ?? 11 ?? FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 19 6F ?? ?? ??
            ?? 6F ?? ?? ?? ?? DE ?? 26 DE ?? 11 ?? 6F ?? ?? ?? ?? 2D ?? DE ?? 11 ?? 2C ?? 11 ?? 6F
            ?? ?? ?? ?? DC DE ?? 26 DE ?? 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 3F ?? ?? ?? ?? 2A
        }

        $remote_connection = {
            73 ?? ?? ?? ?? 0A 00 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 7E ?? ?? ?? ?? 17 28 ?? ?? ??
            ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 1C 6F ?? ?? ?? ?? 2B ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ??
            1C 6F ?? ?? ?? ?? 06 7E ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 20 ?? ?? ?? ?? 28 ??
            ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 17 0B DE ?? 26 72 ?? ?? ?? ??
            28 ?? ?? ?? ?? 20 ?? ?? ?? ?? 28 ?? ?? ?? ?? DE ?? 07 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            $encrypt_file
        ) and
        (
            $aes_encrypt
        ) and
        (
            $remote_connection
        )
}